package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteBucketRequest(bucketName: primitives.BucketName, forceDelete: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest = {
    import DeleteBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest.builder().bucketName(bucketName: java.lang.String).optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(_.forceDelete).build()
  }
  def asReadOnly: DeleteBucketRequest.ReadOnly = DeleteBucketRequest.wrap(buildAwsValue())
}
object DeleteBucketRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteBucketRequest = DeleteBucketRequest(bucketNameValue, forceDeleteValue.map(value => value))
    def bucketNameValue: primitives.BucketName
    def forceDeleteValue: scala.Option[Boolean]
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
    def forceDelete: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forceDelete", forceDeleteValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest) extends DeleteBucketRequest.ReadOnly {
    override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName
    override def forceDeleteValue: scala.Option[Boolean] = scala.Option(impl.forceDelete()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest): ReadOnly = new Wrapper(impl)
}