package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLoadBalancerTlsCertificateRequest(loadBalancerName: primitives.ResourceName, certificateName: primitives.ResourceName, certificateDomainName: primitives.DomainName, certificateAlternativeNames: scala.Option[Iterable[primitives.DomainName]] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest = {
    import CreateLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).certificateName(certificateName: java.lang.String).certificateDomainName(certificateDomainName: java.lang.String).optionallyWith(certificateAlternativeNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.certificateAlternativeNames).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateLoadBalancerTlsCertificateRequest.ReadOnly = CreateLoadBalancerTlsCertificateRequest.wrap(buildAwsValue())
}
object CreateLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLoadBalancerTlsCertificateRequest = CreateLoadBalancerTlsCertificateRequest(loadBalancerNameValue, certificateNameValue, certificateDomainNameValue, certificateAlternativeNamesValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def loadBalancerNameValue: primitives.ResourceName
    def certificateNameValue: primitives.ResourceName
    def certificateDomainNameValue: primitives.DomainName
    def certificateAlternativeNamesValue: scala.Option[List[primitives.DomainName]]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
    def certificateName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(certificateNameValue)
    def certificateDomainName: ZIO[Any, Nothing, primitives.DomainName] = ZIO.succeed(certificateDomainNameValue)
    def certificateAlternativeNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.DomainName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateAlternativeNames", certificateAlternativeNamesValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest) extends CreateLoadBalancerTlsCertificateRequest.ReadOnly {
    override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName
    override def certificateNameValue: primitives.ResourceName = impl.certificateName(): primitives.ResourceName
    override def certificateDomainNameValue: primitives.DomainName = impl.certificateDomainName(): primitives.DomainName
    override def certificateAlternativeNamesValue: scala.Option[List[primitives.DomainName]] = scala.Option(impl.certificateAlternativeNames()).map(value => value.asScala.map { item => 
      item: primitives.DomainName
    }.toList)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest): ReadOnly = new Wrapper(impl)
}