package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AutoSnapshotDetails(date: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, status: scala.Option[AutoSnapshotStatus] = None, fromAttachedDisks: scala.Option[Iterable[AttachedDisk]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails = {
    import AutoSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails.builder().optionallyWith(date.map(value => value: java.lang.String))(_.date).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(fromAttachedDisks.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.fromAttachedDisks).build()
  }
  def asReadOnly: AutoSnapshotDetails.ReadOnly = AutoSnapshotDetails.wrap(buildAwsValue())
}
object AutoSnapshotDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AutoSnapshotDetails = AutoSnapshotDetails(dateValue.map(value => value), createdAtValue.map(value => value), statusValue.map(value => value), fromAttachedDisksValue.map(value => value.map { item => 
      item.editable
    }))
    def dateValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def statusValue: scala.Option[AutoSnapshotStatus]
    def fromAttachedDisksValue: scala.Option[List[AttachedDisk.ReadOnly]]
    def date: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("date", dateValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AutoSnapshotStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def fromAttachedDisks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AttachedDisk.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromAttachedDisks", fromAttachedDisksValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails) extends AutoSnapshotDetails.ReadOnly {
    override def dateValue: scala.Option[String] = scala.Option(impl.date()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def statusValue: scala.Option[AutoSnapshotStatus] = scala.Option(impl.status()).map(value => AutoSnapshotStatus.wrap(value))
    override def fromAttachedDisksValue: scala.Option[List[AttachedDisk.ReadOnly]] = scala.Option(impl.fromAttachedDisks()).map(value => value.asScala.map { item => 
      AttachedDisk.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails): ReadOnly = new Wrapper(impl)
}