package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  SensitiveString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    masterUserPassword: Option[SensitiveString] = None,
    rotateMasterUserPassword: Option[Boolean] = None,
    preferredBackupWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    enableBackupRetention: Option[Boolean] = None,
    disableBackupRetention: Option[Boolean] = None,
    publiclyAccessible: Option[Boolean] = None,
    applyImmediately: Option[Boolean] = None,
    caCertificateIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest = {
    import UpdateRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        rotateMasterUserPassword.map(value => value: java.lang.Boolean)
      )(_.rotateMasterUserPassword)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        enableBackupRetention.map(value => value: java.lang.Boolean)
      )(_.enableBackupRetention)
      .optionallyWith(
        disableBackupRetention.map(value => value: java.lang.Boolean)
      )(_.disableBackupRetention)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object UpdateRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseRequest =
      io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseRequest(
        relationalDatabaseNameValue,
        masterUserPasswordValue.map(value => value),
        rotateMasterUserPasswordValue.map(value => value),
        preferredBackupWindowValue.map(value => value),
        preferredMaintenanceWindowValue.map(value => value),
        enableBackupRetentionValue.map(value => value),
        disableBackupRetentionValue.map(value => value),
        publiclyAccessibleValue.map(value => value),
        applyImmediatelyValue.map(value => value),
        caCertificateIdentifierValue.map(value => value)
      )
    def relationalDatabaseNameValue: ResourceName
    def masterUserPasswordValue: Option[SensitiveString]
    def rotateMasterUserPasswordValue: Option[Boolean]
    def preferredBackupWindowValue: Option[String]
    def preferredMaintenanceWindowValue: Option[String]
    def enableBackupRetentionValue: Option[Boolean]
    def disableBackupRetentionValue: Option[Boolean]
    def publiclyAccessibleValue: Option[Boolean]
    def applyImmediatelyValue: Option[Boolean]
    def caCertificateIdentifierValue: Option[String]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def masterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def rotateMasterUserPassword: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "rotateMasterUserPassword",
        rotateMasterUserPasswordValue
      )
    def preferredBackupWindow: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindowValue
      )
    def enableBackupRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableBackupRetention", enableBackupRetentionValue)
    def disableBackupRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableBackupRetention", disableBackupRetentionValue)
    def publiclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def applyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediatelyValue)
    def caCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "caCertificateIdentifier",
        caCertificateIdentifierValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def masterUserPasswordValue: Option[SensitiveString] = scala
      .Option(impl.masterUserPassword())
      .map(value => value: SensitiveString)
    override def rotateMasterUserPasswordValue: Option[Boolean] =
      scala.Option(impl.rotateMasterUserPassword()).map(value => value: Boolean)
    override def preferredBackupWindowValue: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def preferredMaintenanceWindowValue: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override def enableBackupRetentionValue: Option[Boolean] =
      scala.Option(impl.enableBackupRetention()).map(value => value: Boolean)
    override def disableBackupRetentionValue: Option[Boolean] =
      scala.Option(impl.disableBackupRetention()).map(value => value: Boolean)
    override def publiclyAccessibleValue: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def applyImmediatelyValue: Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override def caCertificateIdentifierValue: Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
