package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  StringMax256,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateLoadBalancerAttributeRequest(
    loadBalancerName: ResourceName,
    attributeName: io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName,
    attributeValue: StringMax256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest = {
    import UpdateLoadBalancerAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .attributeName(attributeName.unwrap)
      .attributeValue(attributeValue: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeRequest
      .wrap(buildAwsValue())
}
object UpdateLoadBalancerAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeRequest =
      io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeRequest(
        loadBalancerNameValue,
        attributeNameValue,
        attributeValueValue
      )
    def loadBalancerNameValue: ResourceName
    def attributeNameValue
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName
    def attributeValueValue: StringMax256
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
    def attributeName: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName
    ] = ZIO.succeed(attributeNameValue)
    def attributeValue: ZIO[Any, Nothing, StringMax256] =
      ZIO.succeed(attributeValueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
    override def attributeNameValue
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName =
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName
        .wrap(impl.attributeName())
    override def attributeValueValue: StringMax256 =
      impl.attributeValue(): StringMax256
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
