package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateBucketBundleRequest(
    bucketName: BucketName,
    bundleId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest = {
    import UpdateBucketBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
      .builder()
      .bucketName(bucketName: java.lang.String)
      .bundleId(bundleId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleRequest
      .wrap(buildAwsValue())
}
object UpdateBucketBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleRequest =
      io.github.vigoo.zioaws.lightsail.model
        .UpdateBucketBundleRequest(bucketNameValue, bundleIdValue)
    def bucketNameValue: BucketName
    def bundleIdValue: NonEmptyString
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def bundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleRequest.ReadOnly {
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def bundleIdValue: NonEmptyString = impl.bundleId(): NonEmptyString
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleRequest.ReadOnly =
    new Wrapper(impl)
}
