package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseBundle(
    bundleId: Option[String] = None,
    name: Option[String] = None,
    price: Option[Float] = None,
    ramSizeInGb: Option[Float] = None,
    diskSizeInGb: Option[Integer] = None,
    transferPerMonthInGb: Option[Integer] = None,
    cpuCount: Option[Integer] = None,
    isEncrypted: Option[Boolean] = None,
    isActive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle = {
    import RelationalDatabaseBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
      .builder()
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(
        _.diskSizeInGb
      )
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(cpuCount.map(value => value: java.lang.Integer))(
        _.cpuCount
      )
      .optionallyWith(isEncrypted.map(value => value: java.lang.Boolean))(
        _.isEncrypted
      )
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle
      .wrap(buildAwsValue())
}
object RelationalDatabaseBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle(
        bundleIdValue.map(value => value),
        nameValue.map(value => value),
        priceValue.map(value => value),
        ramSizeInGbValue.map(value => value),
        diskSizeInGbValue.map(value => value),
        transferPerMonthInGbValue.map(value => value),
        cpuCountValue.map(value => value),
        isEncryptedValue.map(value => value),
        isActiveValue.map(value => value)
      )
    def bundleIdValue: Option[String]
    def nameValue: Option[String]
    def priceValue: Option[Float]
    def ramSizeInGbValue: Option[Float]
    def diskSizeInGbValue: Option[Integer]
    def transferPerMonthInGbValue: Option[Integer]
    def cpuCountValue: Option[Integer]
    def isEncryptedValue: Option[Boolean]
    def isActiveValue: Option[Boolean]
    def bundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def price: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", priceValue)
    def ramSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
    def diskSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGbValue)
    def transferPerMonthInGb: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("transferPerMonthInGb", transferPerMonthInGbValue)
    def cpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def isEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEncrypted", isEncryptedValue)
    def isActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActiveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle.ReadOnly {
    override def bundleIdValue: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def priceValue: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override def ramSizeInGbValue: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override def diskSizeInGbValue: Option[Integer] =
      scala.Option(impl.diskSizeInGb()).map(value => value: Integer)
    override def transferPerMonthInGbValue: Option[Integer] =
      scala.Option(impl.transferPerMonthInGb()).map(value => value: Integer)
    override def cpuCountValue: Option[Integer] =
      scala.Option(impl.cpuCount()).map(value => value: Integer)
    override def isEncryptedValue: Option[Boolean] =
      scala.Option(impl.isEncrypted()).map(value => value: Boolean)
    override def isActiveValue: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle.ReadOnly =
    new Wrapper(impl)
}
