package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabase(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    relationalDatabaseBlueprintId: Option[NonEmptyString] = None,
    relationalDatabaseBundleId: Option[NonEmptyString] = None,
    masterDatabaseName: Option[String] = None,
    hardware: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware
    ] = None,
    state: Option[NonEmptyString] = None,
    secondaryAvailabilityZone: Option[String] = None,
    backupRetentionEnabled: Option[Boolean] = None,
    pendingModifiedValues: Option[
      io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues
    ] = None,
    engine: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    latestRestorableTime: Option[IsoDate] = None,
    masterUsername: Option[NonEmptyString] = None,
    parameterApplyStatus: Option[NonEmptyString] = None,
    preferredBackupWindow: Option[NonEmptyString] = None,
    preferredMaintenanceWindow: Option[NonEmptyString] = None,
    publiclyAccessible: Option[Boolean] = None,
    masterEndpoint: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint
    ] = None,
    pendingMaintenanceActions: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction]
    ] = None,
    caCertificateIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabase = {
    import RelationalDatabase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabase
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        relationalDatabaseBlueprintId.map(value => value: java.lang.String)
      )(_.relationalDatabaseBlueprintId)
      .optionallyWith(
        relationalDatabaseBundleId.map(value => value: java.lang.String)
      )(_.relationalDatabaseBundleId)
      .optionallyWith(masterDatabaseName.map(value => value: java.lang.String))(
        _.masterDatabaseName
      )
      .optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        backupRetentionEnabled.map(value => value: java.lang.Boolean)
      )(_.backupRetentionEnabled)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(latestRestorableTime.map(value => value: Instant))(
        _.latestRestorableTime
      )
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(masterEndpoint.map(value => value.buildAwsValue()))(
        _.masterEndpoint
      )
      .optionallyWith(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActions)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabase
      .wrap(buildAwsValue())
}
object RelationalDatabase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.RelationalDatabase =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabase(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        relationalDatabaseBlueprintIdValue.map(value => value),
        relationalDatabaseBundleIdValue.map(value => value),
        masterDatabaseNameValue.map(value => value),
        hardwareValue.map(value => value.editable),
        stateValue.map(value => value),
        secondaryAvailabilityZoneValue.map(value => value),
        backupRetentionEnabledValue.map(value => value),
        pendingModifiedValuesValue.map(value => value.editable),
        engineValue.map(value => value),
        engineVersionValue.map(value => value),
        latestRestorableTimeValue.map(value => value),
        masterUsernameValue.map(value => value),
        parameterApplyStatusValue.map(value => value),
        preferredBackupWindowValue.map(value => value),
        preferredMaintenanceWindowValue.map(value => value),
        publiclyAccessibleValue.map(value => value),
        masterEndpointValue.map(value => value.editable),
        pendingMaintenanceActionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        caCertificateIdentifierValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def relationalDatabaseBlueprintIdValue: Option[NonEmptyString]
    def relationalDatabaseBundleIdValue: Option[NonEmptyString]
    def masterDatabaseNameValue: Option[String]
    def hardwareValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware.ReadOnly
    ]
    def stateValue: Option[NonEmptyString]
    def secondaryAvailabilityZoneValue: Option[String]
    def backupRetentionEnabledValue: Option[Boolean]
    def pendingModifiedValuesValue: Option[
      io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ]
    def engineValue: Option[NonEmptyString]
    def engineVersionValue: Option[NonEmptyString]
    def latestRestorableTimeValue: Option[IsoDate]
    def masterUsernameValue: Option[NonEmptyString]
    def parameterApplyStatusValue: Option[NonEmptyString]
    def preferredBackupWindowValue: Option[NonEmptyString]
    def preferredMaintenanceWindowValue: Option[NonEmptyString]
    def publiclyAccessibleValue: Option[Boolean]
    def masterEndpointValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly
    ]
    def pendingMaintenanceActionsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction.ReadOnly
    ]]
    def caCertificateIdentifierValue: Option[String]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def relationalDatabaseBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBlueprintId",
        relationalDatabaseBlueprintIdValue
      )
    def relationalDatabaseBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBundleId",
        relationalDatabaseBundleIdValue
      )
    def masterDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterDatabaseName", masterDatabaseNameValue)
    def hardware: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware.ReadOnly
    ] = AwsError.unwrapOptionField("hardware", hardwareValue)
    def state: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", stateValue)
    def secondaryAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secondaryAvailabilityZone",
        secondaryAvailabilityZoneValue
      )
    def backupRetentionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("backupRetentionEnabled", backupRetentionEnabledValue)
    def pendingModifiedValues: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingModifiedValues",
      pendingModifiedValuesValue
    )
    def engine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def latestRestorableTime: ZIO[Any, AwsError, IsoDate] = AwsError
      .unwrapOptionField("latestRestorableTime", latestRestorableTimeValue)
    def masterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
    def parameterApplyStatus: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("parameterApplyStatus", parameterApplyStatusValue)
    def preferredBackupWindow: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindowValue
      )
    def publiclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def masterEndpoint: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("masterEndpoint", masterEndpointValue)
    def pendingMaintenanceActions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActions",
      pendingMaintenanceActionsValue
    )
    def caCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "caCertificateIdentifier",
        caCertificateIdentifierValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def relationalDatabaseBlueprintIdValue: Option[NonEmptyString] =
      scala
        .Option(impl.relationalDatabaseBlueprintId())
        .map(value => value: NonEmptyString)
    override def relationalDatabaseBundleIdValue: Option[NonEmptyString] = scala
      .Option(impl.relationalDatabaseBundleId())
      .map(value => value: NonEmptyString)
    override def masterDatabaseNameValue: Option[String] =
      scala.Option(impl.masterDatabaseName()).map(value => value: String)
    override def hardwareValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware.ReadOnly
    ] = scala
      .Option(impl.hardware())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware
          .wrap(value)
      )
    override def stateValue: Option[NonEmptyString] =
      scala.Option(impl.state()).map(value => value: NonEmptyString)
    override def secondaryAvailabilityZoneValue: Option[String] =
      scala.Option(impl.secondaryAvailabilityZone()).map(value => value: String)
    override def backupRetentionEnabledValue: Option[Boolean] =
      scala.Option(impl.backupRetentionEnabled()).map(value => value: Boolean)
    override def pendingModifiedValuesValue: Option[
      io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ] = scala
      .Option(impl.pendingModifiedValues())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues
          .wrap(value)
      )
    override def engineValue: Option[NonEmptyString] =
      scala.Option(impl.engine()).map(value => value: NonEmptyString)
    override def engineVersionValue: Option[NonEmptyString] =
      scala.Option(impl.engineVersion()).map(value => value: NonEmptyString)
    override def latestRestorableTimeValue: Option[IsoDate] =
      scala.Option(impl.latestRestorableTime()).map(value => value: IsoDate)
    override def masterUsernameValue: Option[NonEmptyString] =
      scala.Option(impl.masterUsername()).map(value => value: NonEmptyString)
    override def parameterApplyStatusValue: Option[NonEmptyString] = scala
      .Option(impl.parameterApplyStatus())
      .map(value => value: NonEmptyString)
    override def preferredBackupWindowValue: Option[NonEmptyString] = scala
      .Option(impl.preferredBackupWindow())
      .map(value => value: NonEmptyString)
    override def preferredMaintenanceWindowValue: Option[NonEmptyString] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: NonEmptyString)
    override def publiclyAccessibleValue: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def masterEndpointValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly
    ] = scala
      .Option(impl.masterEndpoint())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint
          .wrap(value)
      )
    override def pendingMaintenanceActionsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction.ReadOnly
    ]] = scala
      .Option(impl.pendingMaintenanceActions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction
            .wrap(item)
        }.toList
      )
    override def caCertificateIdentifierValue: Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly =
    new Wrapper(impl)
}
