package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RebootInstanceRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest = {
    import RebootInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RebootInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RebootInstanceRequest
      .wrap(buildAwsValue())
}
object RebootInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.RebootInstanceRequest =
      io.github.vigoo.zioaws.lightsail.model
        .RebootInstanceRequest(instanceNameValue)
    def instanceNameValue: ResourceName
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.RebootInstanceRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
  ): io.github.vigoo.zioaws.lightsail.model.RebootInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
