package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutInstancePublicPortsRequest(
    portInfos: Iterable[io.github.vigoo.zioaws.lightsail.model.PortInfo],
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest = {
    import PutInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
      .builder()
      .portInfos(portInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsRequest
      .wrap(buildAwsValue())
}
object PutInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsRequest =
      io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsRequest(
        portInfosValue.map { item =>
          item.editable
        },
        instanceNameValue
      )
    def portInfosValue
        : List[io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly]
    def instanceNameValue: ResourceName
    def portInfos: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly
    ]] = ZIO.succeed(portInfosValue)
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsRequest.ReadOnly {
    override def portInfosValue
        : List[io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly] = impl
      .portInfos()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.PortInfo.wrap(item)
      }
      .toList
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
  ): io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsRequest.ReadOnly =
    new Wrapper(impl)
}
