package io.github.vigoo.zioaws.lightsail.model
import java.lang.Integer
import io.github.vigoo.zioaws.lightsail.model.primitives.Port
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstancePortInfo(
    fromPort: Option[Port] = None,
    toPort: Option[Port] = None,
    protocol: Option[io.github.vigoo.zioaws.lightsail.model.NetworkProtocol] =
      None,
    accessFrom: Option[String] = None,
    accessType: Option[io.github.vigoo.zioaws.lightsail.model.PortAccessType] =
      None,
    commonName: Option[String] = None,
    accessDirection: Option[
      io.github.vigoo.zioaws.lightsail.model.AccessDirection
    ] = None,
    cidrs: Option[Iterable[String]] = None,
    ipv6Cidrs: Option[Iterable[String]] = None,
    cidrListAliases: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstancePortInfo = {
    import InstancePortInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstancePortInfo
      .builder()
      .optionallyWith(fromPort.map(value => value: Integer))(_.fromPort)
      .optionallyWith(toPort.map(value => value: Integer))(_.toPort)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(accessFrom.map(value => value: java.lang.String))(
        _.accessFrom
      )
      .optionallyWith(accessType.map(value => value.unwrap))(_.accessType)
      .optionallyWith(commonName.map(value => value: java.lang.String))(
        _.commonName
      )
      .optionallyWith(accessDirection.map(value => value.unwrap))(
        _.accessDirection
      )
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(
        ipv6Cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Cidrs)
      .optionallyWith(
        cidrListAliases.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrListAliases)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstancePortInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstancePortInfo
      .wrap(buildAwsValue())
}
object InstancePortInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstancePortInfo =
      io.github.vigoo.zioaws.lightsail.model.InstancePortInfo(
        fromPortValue.map(value => value),
        toPortValue.map(value => value),
        protocolValue.map(value => value),
        accessFromValue.map(value => value),
        accessTypeValue.map(value => value),
        commonNameValue.map(value => value),
        accessDirectionValue.map(value => value),
        cidrsValue.map(value => value),
        ipv6CidrsValue.map(value => value),
        cidrListAliasesValue.map(value => value)
      )
    def fromPortValue: Option[Port]
    def toPortValue: Option[Port]
    def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.NetworkProtocol]
    def accessFromValue: Option[String]
    def accessTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.PortAccessType]
    def commonNameValue: Option[String]
    def accessDirectionValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessDirection]
    def cidrsValue: Option[List[String]]
    def ipv6CidrsValue: Option[List[String]]
    def cidrListAliasesValue: Option[List[String]]
    def fromPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("fromPort", fromPortValue)
    def toPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("toPort", toPortValue)
    def protocol: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.NetworkProtocol
    ] = AwsError.unwrapOptionField("protocol", protocolValue)
    def accessFrom: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessFrom", accessFromValue)
    def accessType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.PortAccessType
    ] = AwsError.unwrapOptionField("accessType", accessTypeValue)
    def commonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("commonName", commonNameValue)
    def accessDirection: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AccessDirection
    ] = AwsError.unwrapOptionField("accessDirection", accessDirectionValue)
    def cidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrsValue)
    def ipv6Cidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Cidrs", ipv6CidrsValue)
    def cidrListAliases: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrListAliases", cidrListAliasesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.InstancePortInfo.ReadOnly {
    override def fromPortValue: Option[Port] =
      scala.Option(impl.fromPort()).map(value => value: Port)
    override def toPortValue: Option[Port] =
      scala.Option(impl.toPort()).map(value => value: Port)
    override def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.NetworkProtocol] = scala
      .Option(impl.protocol())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.NetworkProtocol.wrap(value)
      )
    override def accessFromValue: Option[String] =
      scala.Option(impl.accessFrom()).map(value => value: String)
    override def accessTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.PortAccessType] = scala
      .Option(impl.accessType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.PortAccessType.wrap(value)
      )
    override def commonNameValue: Option[String] =
      scala.Option(impl.commonName()).map(value => value: String)
    override def accessDirectionValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessDirection] = scala
      .Option(impl.accessDirection())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.AccessDirection.wrap(value)
      )
    override def cidrsValue: Option[List[String]] = scala
      .Option(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def ipv6CidrsValue: Option[List[String]] = scala
      .Option(impl.ipv6Cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def cidrListAliasesValue: Option[List[String]] = scala
      .Option(impl.cidrListAliases())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ): io.github.vigoo.zioaws.lightsail.model.InstancePortInfo.ReadOnly =
    new Wrapper(impl)
}
