package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.BuilderHelper
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  MetricPeriod,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseMetricDataRequest(
    relationalDatabaseName: ResourceName,
    metricName: io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName,
    period: MetricPeriod,
    startTime: IsoDate,
    endTime: IsoDate,
    unit: io.github.vigoo.zioaws.lightsail.model.MetricUnit,
    statistics: Iterable[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest = {
    import GetRelationalDatabaseMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .metricName(metricName.unwrap)
      .period(period: Integer)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .unit(unit.unwrap)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseMetricDataRequest(
          relationalDatabaseNameValue,
          metricNameValue,
          periodValue,
          startTimeValue,
          endTimeValue,
          unitValue,
          statisticsValue
        )
    def relationalDatabaseNameValue: ResourceName
    def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName
    def periodValue: MetricPeriod
    def startTimeValue: IsoDate
    def endTimeValue: IsoDate
    def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit
    def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def metricName: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName
    ] = ZIO.succeed(metricNameValue)
    def period: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(periodValue)
    def startTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(endTimeValue)
    def unit
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.MetricUnit] =
      ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName
        .wrap(impl.metricName())
    override def periodValue: MetricPeriod = impl.period(): MetricPeriod
    override def startTimeValue: IsoDate = impl.startTime(): IsoDate
    override def endTimeValue: IsoDate = impl.endTime(): IsoDate
    override def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit =
      io.github.vigoo.zioaws.lightsail.model.MetricUnit.wrap(impl.unit())
    override def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] = impl
      .statistics()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.MetricStatistic.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
