package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseLogStreamsRequest(
    relationalDatabaseName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest = {
    import GetRelationalDatabaseLogStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseLogStreamsRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsRequest.ReadOnly =
    new Wrapper(impl)
}
