package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.BuilderHelper
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Timestamp,
  MetricPeriod,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerMetricDataRequest(
    loadBalancerName: ResourceName,
    metricName: io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName,
    period: MetricPeriod,
    startTime: Timestamp,
    endTime: Timestamp,
    unit: io.github.vigoo.zioaws.lightsail.model.MetricUnit,
    statistics: Iterable[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest = {
    import GetLoadBalancerMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .metricName(metricName.unwrap)
      .period(period: Integer)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .unit(unit.unwrap)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataRequest
      .wrap(buildAwsValue())
}
object GetLoadBalancerMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataRequest =
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataRequest(
        loadBalancerNameValue,
        metricNameValue,
        periodValue,
        startTimeValue,
        endTimeValue,
        unitValue,
        statisticsValue
      )
    def loadBalancerNameValue: ResourceName
    def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName
    def periodValue: MetricPeriod
    def startTimeValue: Timestamp
    def endTimeValue: Timestamp
    def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit
    def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
    def metricName: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName
    ] = ZIO.succeed(metricNameValue)
    def period: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(periodValue)
    def startTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTimeValue)
    def unit
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.MetricUnit] =
      ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
    override def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName =
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName
        .wrap(impl.metricName())
    override def periodValue: MetricPeriod = impl.period(): MetricPeriod
    override def startTimeValue: Timestamp = impl.startTime(): Timestamp
    override def endTimeValue: Timestamp = impl.endTime(): Timestamp
    override def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit =
      io.github.vigoo.zioaws.lightsail.model.MetricUnit.wrap(impl.unit())
    override def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] = impl
      .statistics()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.MetricStatistic.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
