package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstanceSnapshotRequest(
    instanceSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest = {
    import GetInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
      .builder()
      .instanceSnapshotName(instanceSnapshotName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotRequest
      .wrap(buildAwsValue())
}
object GetInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetInstanceSnapshotRequest(instanceSnapshotNameValue)
    def instanceSnapshotNameValue: ResourceName
    def instanceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceSnapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotRequest.ReadOnly {
    override def instanceSnapshotNameValue: ResourceName =
      impl.instanceSnapshotName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
