package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstanceRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceRequest = {
    import GetInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceRequest
      .wrap(buildAwsValue())
}
object GetInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetInstanceRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetInstanceRequest(instanceNameValue)
    def instanceNameValue: ResourceName
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
