package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDomainResponse(
    domain: Option[io.github.vigoo.zioaws.lightsail.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDomainResponse = {
    import GetDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainResponse
      .builder()
      .optionallyWith(domain.map(value => value.buildAwsValue()))(_.domain)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDomainResponse
      .wrap(buildAwsValue())
}
object GetDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetDomainResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetDomainResponse(domainValue.map(value => value.editable))
    def domainValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Domain.ReadOnly]
    def domain: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Domain.ReadOnly
    ] = AwsError.unwrapOptionField("domain", domainValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly {
    override def domainValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Domain.ReadOnly] = scala
      .Option(impl.domain())
      .map(value => io.github.vigoo.zioaws.lightsail.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly =
    new Wrapper(impl)
}
