package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerServicesResponse(
    containerServices: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContainerService]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse = {
    import GetContainerServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
      .builder()
      .optionallyWith(
        containerServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerServices)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse
      .wrap(buildAwsValue())
}
object GetContainerServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse(
        containerServicesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def containerServicesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly]
    ]
    def containerServices: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly
    ]] = AwsError.unwrapOptionField("containerServices", containerServicesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly {
    override def containerServicesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly]
    ] = scala
      .Option(impl.containerServices())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ContainerService.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly =
    new Wrapper(impl)
}
