package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAlarmsResponse(
    alarms: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Alarm]] =
      None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse = {
    import GetAlarmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
      .builder()
      .optionallyWith(
        alarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarms)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse
      .wrap(buildAwsValue())
}
object GetAlarmsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse(
        alarmsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def alarmsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Alarm.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def alarms: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Alarm.ReadOnly
    ]] = AwsError.unwrapOptionField("alarms", alarmsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly {
    override def alarmsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Alarm.ReadOnly]] =
      scala
        .Option(impl.alarms())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Alarm.wrap(item)
          }.toList
        )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly =
    new Wrapper(impl)
}
