package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest = {
    import DetachStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
      .builder()
      .staticIpName(staticIpName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DetachStaticIpRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DetachStaticIpRequest
      .wrap(buildAwsValue())
}
object DetachStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DetachStaticIpRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DetachStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: ResourceName
    def staticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DetachStaticIpRequest.ReadOnly {
    override def staticIpNameValue: ResourceName =
      impl.staticIpName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
  ): io.github.vigoo.zioaws.lightsail.model.DetachStaticIpRequest.ReadOnly =
    new Wrapper(impl)
}
