package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBucketResponse(
    bucket: Option[io.github.vigoo.zioaws.lightsail.model.Bucket] = None,
    operations: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Operation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateBucketResponse = {
    import CreateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
      .builder()
      .optionallyWith(bucket.map(value => value.buildAwsValue()))(_.bucket)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse
      .wrap(buildAwsValue())
}
object CreateBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse =
      io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse(
        bucketValue.map(value => value.editable),
        operationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def bucketValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly]
    def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ]
    def bucket: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly
    ] = AwsError.unwrapOptionField("bucket", bucketValue)
    def operations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ]] = AwsError.unwrapOptionField("operations", operationsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly {
    override def bucketValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly] = scala
      .Option(impl.bucket())
      .map(value => io.github.vigoo.zioaws.lightsail.model.Bucket.wrap(value))
    override def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly =
    new Wrapper(impl)
}
