package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  ContainerName,
  Integer
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServiceDeployment(
    version: Option[Integer] = None,
    state: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentState
    ] = None,
    containers: Option[
      Map[ContainerName, io.github.vigoo.zioaws.lightsail.model.Container]
    ] = None,
    publicEndpoint: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint
    ] = None,
    createdAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment = {
    import ContainerServiceDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
      .builder()
      .optionallyWith(version.map(value => value: java.lang.Integer))(_.version)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        containers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.containers)
      .optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(
        _.publicEndpoint
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment
      .wrap(buildAwsValue())
}
object ContainerServiceDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment =
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment(
        versionValue.map(value => value),
        stateValue.map(value => value),
        containersValue.map(value =>
          value.map({ case (key, value) =>
            key -> value.editable
          })
        ),
        publicEndpointValue.map(value => value.editable),
        createdAtValue.map(value => value)
      )
    def versionValue: Option[Integer]
    def stateValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentState
    ]
    def containersValue: Option[Map[
      ContainerName,
      io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly
    ]]
    def publicEndpointValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint.ReadOnly
    ]
    def createdAtValue: Option[IsoDate]
    def version: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("version", versionValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def containers: ZIO[Any, AwsError, Map[
      ContainerName,
      io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containersValue)
    def publicEndpoint: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("publicEndpoint", publicEndpointValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly {
    override def versionValue: Option[Integer] =
      scala.Option(impl.version()).map(value => value: Integer)
    override def stateValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentState
    ] = scala
      .Option(impl.state())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentState
          .wrap(value)
      )
    override def containersValue: Option[Map[
      ContainerName,
      io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly
    ]] = scala
      .Option(impl.containers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: ContainerName) -> io.github.vigoo.zioaws.lightsail.model.Container
              .wrap(value)
          })
          .toMap
      )
    override def publicEndpointValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint.ReadOnly
    ] = scala
      .Option(impl.publicEndpoint())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint
          .wrap(value)
      )
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly =
    new Wrapper(impl)
}
