package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDistributionRequest(
    distributionName: ResourceName,
    origin: Option[io.github.vigoo.zioaws.lightsail.model.InputOrigin] = None,
    defaultCacheBehavior: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior
    ] = None,
    cacheBehaviorSettings: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheSettings
    ] = None,
    cacheBehaviors: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath]
    ] = None,
    isEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest = {
    import UpdateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
      .builder()
      .distributionName(distributionName: java.lang.String)
      .optionallyWith(origin.map(value => value.buildAwsValue()))(_.origin)
      .optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(
        _.defaultCacheBehavior
      )
      .optionallyWith(
        cacheBehaviorSettings.map(value => value.buildAwsValue())
      )(_.cacheBehaviorSettings)
      .optionallyWith(
        cacheBehaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheBehaviors)
      .optionallyWith(isEnabled.map(value => value: java.lang.Boolean))(
        _.isEnabled
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateDistributionRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateDistributionRequest
      .wrap(buildAwsValue())
}
object UpdateDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateDistributionRequest =
      io.github.vigoo.zioaws.lightsail.model.UpdateDistributionRequest(
        distributionNameValue,
        originValue.map(value => value.editable),
        defaultCacheBehaviorValue.map(value => value.editable),
        cacheBehaviorSettingsValue.map(value => value.editable),
        cacheBehaviorsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        isEnabledValue.map(value => value)
      )
    def distributionNameValue: ResourceName
    def originValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InputOrigin.ReadOnly]
    def defaultCacheBehaviorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly]
    def cacheBehaviorSettingsValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly]
    def cacheBehaviorsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ]
    def isEnabledValue: Option[Boolean]
    def distributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionNameValue)
    def origin: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InputOrigin.ReadOnly
    ] = AwsError.unwrapOptionField("origin", originValue)
    def defaultCacheBehavior: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultCacheBehavior",
      defaultCacheBehaviorValue
    )
    def cacheBehaviorSettings: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cacheBehaviorSettings",
      cacheBehaviorSettingsValue
    )
    def cacheBehaviors: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviorsValue)
    def isEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEnabled", isEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateDistributionRequest.ReadOnly {
    override def distributionNameValue: ResourceName =
      impl.distributionName(): ResourceName
    override def originValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InputOrigin.ReadOnly] =
      scala
        .Option(impl.origin())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.InputOrigin.wrap(value)
        )
    override def defaultCacheBehaviorValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly
    ] = scala
      .Option(impl.defaultCacheBehavior())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.CacheBehavior.wrap(value)
      )
    override def cacheBehaviorSettingsValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly
    ] = scala
      .Option(impl.cacheBehaviorSettings())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.CacheSettings.wrap(value)
      )
    override def cacheBehaviorsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ] = scala
      .Option(impl.cacheBehaviors())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.wrap(item)
        }.toList
      )
    override def isEnabledValue: Option[Boolean] =
      scala.Option(impl.isEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
