package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait RenewalStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.RenewalStatus
}
object RenewalStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.RenewalStatus
  ): io.github.vigoo.zioaws.lightsail.model.RenewalStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_AUTO_RENEWAL =>
      val r = PendingAutoRenewal
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_VALIDATION =>
      val r = PendingValidation
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.lightsail.model.RenewalStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PendingAutoRenewal
      extends io.github.vigoo.zioaws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_AUTO_RENEWAL
  }
  case object PendingValidation
      extends io.github.vigoo.zioaws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.PENDING_VALIDATION
  }
  case object Success
      extends io.github.vigoo.zioaws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.SUCCESS
  }
  case object Failed
      extends io.github.vigoo.zioaws.lightsail.model.RenewalStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RenewalStatus =
      software.amazon.awssdk.services.lightsail.model.RenewalStatus.FAILED
  }
}
