package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{IsoDate, ResourceName}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseEvent(
    resource: Option[ResourceName] = None,
    createdAt: Option[IsoDate] = None,
    message: Option[String] = None,
    eventCategories: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent = {
    import RelationalDatabaseEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
      .builder()
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent
      .wrap(buildAwsValue())
}
object RelationalDatabaseEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent(
        resourceValue.map(value => value),
        createdAtValue.map(value => value),
        messageValue.map(value => value),
        eventCategoriesValue.map(value => value)
      )
    def resourceValue: Option[ResourceName]
    def createdAtValue: Option[IsoDate]
    def messageValue: Option[String]
    def eventCategoriesValue: Option[List[String]]
    def resource: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resource", resourceValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def message: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", messageValue)
    def eventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent.ReadOnly {
    override def resourceValue: Option[ResourceName] =
      scala.Option(impl.resource()).map(value => value: ResourceName)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def messageValue: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override def eventCategoriesValue: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent.ReadOnly =
    new Wrapper(impl)
}
