package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ContainerLabel,
  ContainerServiceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterContainerImageRequest(
    serviceName: ContainerServiceName,
    label: ContainerLabel,
    digest: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest = {
    import RegisterContainerImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .label(label: java.lang.String)
      .digest(digest: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageRequest
      .wrap(buildAwsValue())
}
object RegisterContainerImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageRequest =
      io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageRequest(
        serviceNameValue,
        labelValue,
        digestValue
      )
    def serviceNameValue: ContainerServiceName
    def labelValue: ContainerLabel
    def digestValue: String
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
    def label: ZIO[Any, Nothing, ContainerLabel] = ZIO.succeed(labelValue)
    def digest: ZIO[Any, Nothing, String] = ZIO.succeed(digestValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
    override def labelValue: ContainerLabel = impl.label(): ContainerLabel
    override def digestValue: String = impl.digest(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
  ): io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageRequest.ReadOnly =
    new Wrapper(impl)
}
