package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Operation(
    id: Option[NonEmptyString] = None,
    resourceName: Option[ResourceName] = None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    isTerminal: Option[Boolean] = None,
    operationDetails: Option[String] = None,
    operationType: Option[
      io.github.vigoo.zioaws.lightsail.model.OperationType
    ] = None,
    status: Option[io.github.vigoo.zioaws.lightsail.model.OperationStatus] =
      None,
    statusChangedAt: Option[IsoDate] = None,
    errorCode: Option[String] = None,
    errorDetails: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Operation = {
    import Operation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Operation
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(isTerminal.map(value => value: java.lang.Boolean))(
        _.isTerminal
      )
      .optionallyWith(operationDetails.map(value => value: java.lang.String))(
        _.operationDetails
      )
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusChangedAt.map(value => value: Instant))(
        _.statusChangedAt
      )
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorDetails.map(value => value: java.lang.String))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Operation.wrap(buildAwsValue())
}
object Operation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Operation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Operation =
      io.github.vigoo.zioaws.lightsail.model.Operation(
        idValue.map(value => value),
        resourceNameValue.map(value => value),
        resourceTypeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        isTerminalValue.map(value => value),
        operationDetailsValue.map(value => value),
        operationTypeValue.map(value => value),
        statusValue.map(value => value),
        statusChangedAtValue.map(value => value),
        errorCodeValue.map(value => value),
        errorDetailsValue.map(value => value)
      )
    def idValue: Option[NonEmptyString]
    def resourceNameValue: Option[ResourceName]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def isTerminalValue: Option[Boolean]
    def operationDetailsValue: Option[String]
    def operationTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.OperationType]
    def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.OperationStatus]
    def statusChangedAtValue: Option[IsoDate]
    def errorCodeValue: Option[String]
    def errorDetailsValue: Option[String]
    def id: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", idValue)
    def resourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceNameValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def isTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTerminal", isTerminalValue)
    def operationDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationDetails", operationDetailsValue)
    def operationType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.OperationType
    ] = AwsError.unwrapOptionField("operationType", operationTypeValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.OperationStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def statusChangedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("statusChangedAt", statusChangedAtValue)
    def errorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCodeValue)
    def errorDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetails", errorDetailsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Operation
  ) extends io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly {
    override def idValue: Option[NonEmptyString] =
      scala.Option(impl.id()).map(value => value: NonEmptyString)
    override def resourceNameValue: Option[ResourceName] =
      scala.Option(impl.resourceName()).map(value => value: ResourceName)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def isTerminalValue: Option[Boolean] =
      scala.Option(impl.isTerminal()).map(value => value: Boolean)
    override def operationDetailsValue: Option[String] =
      scala.Option(impl.operationDetails()).map(value => value: String)
    override def operationTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.OperationType] = scala
      .Option(impl.operationType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.OperationType.wrap(value)
      )
    override def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.OperationStatus] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.OperationStatus.wrap(value)
      )
    override def statusChangedAtValue: Option[IsoDate] =
      scala.Option(impl.statusChangedAt()).map(value => value: IsoDate)
    override def errorCodeValue: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override def errorDetailsValue: Option[String] =
      scala.Option(impl.errorDetails()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Operation
  ): io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly = new Wrapper(
    impl
  )
}
