package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceMetricName {
  def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceMetricName
}
object InstanceMetricName {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstanceMetricName
  ): io.github.vigoo.zioaws.lightsail.model.InstanceMetricName = value match {
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.CPU_UTILIZATION =>
      val r = CPUUtilization
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.NETWORK_IN =>
      val r = NetworkIn
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.NETWORK_OUT =>
      val r = NetworkOut
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.STATUS_CHECK_FAILED =>
      val r = StatusCheckFailed
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.STATUS_CHECK_FAILED_INSTANCE =>
      val r = StatusCheckFailed_Instance
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.STATUS_CHECK_FAILED_SYSTEM =>
      val r = StatusCheckFailed_System
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.BURST_CAPACITY_TIME =>
      val r = BurstCapacityTime
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetricName.BURST_CAPACITY_PERCENTAGE =>
      val r = BurstCapacityPercentage
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object CPUUtilization
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.CPU_UTILIZATION
  }
  case object NetworkIn
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.NETWORK_IN
  }
  case object NetworkOut
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.NETWORK_OUT
  }
  case object StatusCheckFailed
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.STATUS_CHECK_FAILED
  }
  case object StatusCheckFailed_Instance
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.STATUS_CHECK_FAILED_INSTANCE
  }
  case object StatusCheckFailed_System
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.STATUS_CHECK_FAILED_SYSTEM
  }
  case object BurstCapacityTime
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.BURST_CAPACITY_TIME
  }
  case object BurstCapacityPercentage
      extends io.github.vigoo.zioaws.lightsail.model.InstanceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetricName =
      software.amazon.awssdk.services.lightsail.model.InstanceMetricName.BURST_CAPACITY_PERCENTAGE
  }
}
