package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStaticIpsRequest(pageToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest = {
    import GetStaticIpsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetStaticIpsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetStaticIpsRequest
      .wrap(buildAwsValue())
}
object GetStaticIpsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetStaticIpsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetStaticIpsRequest(pageTokenValue.map(value => value))
    def pageTokenValue: Option[String]
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetStaticIpsRequest.ReadOnly {
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetStaticIpsRequest.ReadOnly =
    new Wrapper(impl)
}
