package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseBlueprintsRequest(
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest = {
    import GetRelationalDatabaseBlueprintsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBlueprintsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseBlueprintsRequest(
          pageTokenValue.map(value => value)
        )
    def pageTokenValue: Option[String]
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsRequest.ReadOnly {
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsRequest.ReadOnly =
    new Wrapper(impl)
}
