package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerTlsCertificatesResponse(
    tlsCertificates: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse = {
    import GetLoadBalancerTlsCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
      .builder()
      .optionallyWith(
        tlsCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tlsCertificates)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse
      .wrap(buildAwsValue())
}
object GetLoadBalancerTlsCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetLoadBalancerTlsCertificatesResponse(
          tlsCertificatesValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def tlsCertificatesValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly
    ]]
    def tlsCertificates: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly
    ]] = AwsError.unwrapOptionField("tlsCertificates", tlsCertificatesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly {
    override def tlsCertificatesValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly
    ]] = scala
      .Option(impl.tlsCertificates())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
