package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceStateResponse(
    state: Option[io.github.vigoo.zioaws.lightsail.model.InstanceState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse = {
    import GetInstanceStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
      .builder()
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse
      .wrap(buildAwsValue())
}
object GetInstanceStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetInstanceStateResponse(stateValue.map(value => value.editable))
    def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly]
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly
    ] = AwsError.unwrapOptionField("state", stateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly {
    override def stateValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly
    ] = scala
      .Option(impl.state())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly =
    new Wrapper(impl)
}
