package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceAccessDetailsRequest(
    instanceName: ResourceName,
    protocol: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest = {
    import GetInstanceAccessDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsRequest
      .wrap(buildAwsValue())
}
object GetInstanceAccessDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsRequest =
      io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsRequest(
        instanceNameValue,
        protocolValue.map(value => value)
      )
    def instanceNameValue: ResourceName
    def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol]
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
    def protocol: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
    ] = AwsError.unwrapOptionField("protocol", protocolValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
    override def protocolValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
    ] = scala
      .Option(impl.protocol())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
