package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetExportSnapshotRecordsResponse(
    exportSnapshotRecords: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse = {
    import GetExportSnapshotRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
      .builder()
      .optionallyWith(
        exportSnapshotRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportSnapshotRecords)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse
      .wrap(buildAwsValue())
}
object GetExportSnapshotRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse(
        exportSnapshotRecordsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def exportSnapshotRecordsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord.ReadOnly]
    ]
    def nextPageTokenValue: Option[String]
    def exportSnapshotRecords: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "exportSnapshotRecords",
      exportSnapshotRecordsValue
    )
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly {
    override def exportSnapshotRecordsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord.ReadOnly]
    ] = scala
      .Option(impl.exportSnapshotRecords())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly =
    new Wrapper(impl)
}
