package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerServicesRequest(
    serviceName: Option[ContainerServiceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest = {
    import GetContainerServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
      .builder()
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerServicesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerServicesRequest
      .wrap(buildAwsValue())
}
object GetContainerServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerServicesRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetContainerServicesRequest(serviceNameValue.map(value => value))
    def serviceNameValue: Option[ContainerServiceName]
    def serviceName: ZIO[Any, AwsError, ContainerServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerServicesRequest.ReadOnly {
    override def serviceNameValue: Option[ContainerServiceName] =
      scala.Option(impl.serviceName()).map(value => value: ContainerServiceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerServicesRequest.ReadOnly =
    new Wrapper(impl)
}
