package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBundlesResponse(
    bundles: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Bundle]] =
      None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBundlesResponse = {
    import GetBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse
      .wrap(buildAwsValue())
}
object GetBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse(
        bundlesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def bundlesValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Bundle.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def bundles: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Bundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundlesValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly {
    override def bundlesValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Bundle.ReadOnly]] =
      scala
        .Option(impl.bundles())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Bundle.wrap(item)
          }.toList
        )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly =
    new Wrapper(impl)
}
