package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DomainValidationRecord(
    domainName: Option[DomainName] = None,
    resourceRecord: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceRecord
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DomainValidationRecord = {
    import DomainValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
      .builder()
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(resourceRecord.map(value => value.buildAwsValue()))(
        _.resourceRecord
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord
      .wrap(buildAwsValue())
}
object DomainValidationRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord =
      io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord(
        domainNameValue.map(value => value),
        resourceRecordValue.map(value => value.editable)
      )
    def domainNameValue: Option[DomainName]
    def resourceRecordValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceRecord.ReadOnly]
    def domainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainNameValue)
    def resourceRecord: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceRecord.ReadOnly
    ] = AwsError.unwrapOptionField("resourceRecord", resourceRecordValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ) extends io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly {
    override def domainNameValue: Option[DomainName] =
      scala.Option(impl.domainName()).map(value => value: DomainName)
    override def resourceRecordValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceRecord.ReadOnly
    ] = scala
      .Option(impl.resourceRecord())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceRecord.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ): io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly =
    new Wrapper(impl)
}
