package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachDiskRequest(diskName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DetachDiskRequest = {
    import DetachDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
      .builder()
      .diskName(diskName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DetachDiskRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DetachDiskRequest
      .wrap(buildAwsValue())
}
object DetachDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DetachDiskRequest =
      io.github.vigoo.zioaws.lightsail.model.DetachDiskRequest(diskNameValue)
    def diskNameValue: ResourceName
    def diskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DetachDiskRequest.ReadOnly {
    override def diskNameValue: ResourceName = impl.diskName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
  ): io.github.vigoo.zioaws.lightsail.model.DetachDiskRequest.ReadOnly =
    new Wrapper(impl)
}
