package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    skipFinalSnapshot: Option[Boolean] = None,
    finalRelationalDatabaseSnapshotName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest = {
    import DeleteRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalRelationalDatabaseSnapshotName.map(value =>
          value: java.lang.String
        )
      )(_.finalRelationalDatabaseSnapshotName)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object DeleteRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseRequest =
      io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseRequest(
        relationalDatabaseNameValue,
        skipFinalSnapshotValue.map(value => value),
        finalRelationalDatabaseSnapshotNameValue.map(value => value)
      )
    def relationalDatabaseNameValue: ResourceName
    def skipFinalSnapshotValue: Option[Boolean]
    def finalRelationalDatabaseSnapshotNameValue: Option[ResourceName]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def skipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshotValue)
    def finalRelationalDatabaseSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "finalRelationalDatabaseSnapshotName",
        finalRelationalDatabaseSnapshotNameValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def skipFinalSnapshotValue: Option[Boolean] =
      scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
    override def finalRelationalDatabaseSnapshotNameValue
        : Option[ResourceName] = scala
      .Option(impl.finalRelationalDatabaseSnapshotName())
      .map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
