package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteKeyPairRequest(keyPairName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest = {
    import DeleteKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
      .builder()
      .keyPairName(keyPairName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairRequest
      .wrap(buildAwsValue())
}
object DeleteKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteKeyPairRequest(keyPairNameValue)
    def keyPairNameValue: ResourceName
    def keyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairRequest.ReadOnly {
    override def keyPairNameValue: ResourceName =
      impl.keyPairName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairRequest.ReadOnly =
    new Wrapper(impl)
}
