package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{IsoDate, ResourceName}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRelationalDatabaseFromSnapshotRequest(
    relationalDatabaseName: ResourceName,
    availabilityZone: Option[String] = None,
    publiclyAccessible: Option[Boolean] = None,
    relationalDatabaseSnapshotName: Option[ResourceName] = None,
    relationalDatabaseBundleId: Option[String] = None,
    sourceRelationalDatabaseName: Option[ResourceName] = None,
    restoreTime: Option[IsoDate] = None,
    useLatestRestorableTime: Option[Boolean] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest = {
    import CreateRelationalDatabaseFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        relationalDatabaseSnapshotName.map(value => value: java.lang.String)
      )(_.relationalDatabaseSnapshotName)
      .optionallyWith(
        relationalDatabaseBundleId.map(value => value: java.lang.String)
      )(_.relationalDatabaseBundleId)
      .optionallyWith(
        sourceRelationalDatabaseName.map(value => value: java.lang.String)
      )(_.sourceRelationalDatabaseName)
      .optionallyWith(restoreTime.map(value => value: Instant))(_.restoreTime)
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateRelationalDatabaseFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .CreateRelationalDatabaseFromSnapshotRequest(
          relationalDatabaseNameValue,
          availabilityZoneValue.map(value => value),
          publiclyAccessibleValue.map(value => value),
          relationalDatabaseSnapshotNameValue.map(value => value),
          relationalDatabaseBundleIdValue.map(value => value),
          sourceRelationalDatabaseNameValue.map(value => value),
          restoreTimeValue.map(value => value),
          useLatestRestorableTimeValue.map(value => value),
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def relationalDatabaseNameValue: ResourceName
    def availabilityZoneValue: Option[String]
    def publiclyAccessibleValue: Option[Boolean]
    def relationalDatabaseSnapshotNameValue: Option[ResourceName]
    def relationalDatabaseBundleIdValue: Option[String]
    def sourceRelationalDatabaseNameValue: Option[ResourceName]
    def restoreTimeValue: Option[IsoDate]
    def useLatestRestorableTimeValue: Option[Boolean]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def availabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def publiclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def relationalDatabaseSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "relationalDatabaseSnapshotName",
        relationalDatabaseSnapshotNameValue
      )
    def relationalDatabaseBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBundleId",
        relationalDatabaseBundleIdValue
      )
    def sourceRelationalDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "sourceRelationalDatabaseName",
        sourceRelationalDatabaseNameValue
      )
    def restoreTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("restoreTime", restoreTimeValue)
    def useLatestRestorableTime: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableTime",
        useLatestRestorableTimeValue
      )
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def availabilityZoneValue: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override def publiclyAccessibleValue: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def relationalDatabaseSnapshotNameValue: Option[ResourceName] =
      scala
        .Option(impl.relationalDatabaseSnapshotName())
        .map(value => value: ResourceName)
    override def relationalDatabaseBundleIdValue: Option[String] = scala
      .Option(impl.relationalDatabaseBundleId())
      .map(value => value: String)
    override def sourceRelationalDatabaseNameValue: Option[ResourceName] = scala
      .Option(impl.sourceRelationalDatabaseName())
      .map(value => value: ResourceName)
    override def restoreTimeValue: Option[IsoDate] =
      scala.Option(impl.restoreTime()).map(value => value: IsoDate)
    override def useLatestRestorableTimeValue: Option[Boolean] =
      scala.Option(impl.useLatestRestorableTime()).map(value => value: Boolean)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
