package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServiceHealthCheckConfig(
    healthyThreshold: Option[Integer] = None,
    unhealthyThreshold: Option[Integer] = None,
    timeoutSeconds: Option[Integer] = None,
    intervalSeconds: Option[Integer] = None,
    path: Option[String] = None,
    successCodes: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig = {
    import ContainerServiceHealthCheckConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
      .builder()
      .optionallyWith(healthyThreshold.map(value => value: java.lang.Integer))(
        _.healthyThreshold
      )
      .optionallyWith(
        unhealthyThreshold.map(value => value: java.lang.Integer)
      )(_.unhealthyThreshold)
      .optionallyWith(timeoutSeconds.map(value => value: java.lang.Integer))(
        _.timeoutSeconds
      )
      .optionallyWith(intervalSeconds.map(value => value: java.lang.Integer))(
        _.intervalSeconds
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(successCodes.map(value => value: java.lang.String))(
        _.successCodes
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig
      .wrap(buildAwsValue())
}
object ContainerServiceHealthCheckConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig =
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig(
        healthyThresholdValue.map(value => value),
        unhealthyThresholdValue.map(value => value),
        timeoutSecondsValue.map(value => value),
        intervalSecondsValue.map(value => value),
        pathValue.map(value => value),
        successCodesValue.map(value => value)
      )
    def healthyThresholdValue: Option[Integer]
    def unhealthyThresholdValue: Option[Integer]
    def timeoutSecondsValue: Option[Integer]
    def intervalSecondsValue: Option[Integer]
    def pathValue: Option[String]
    def successCodesValue: Option[String]
    def healthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("healthyThreshold", healthyThresholdValue)
    def unhealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThresholdValue)
    def timeoutSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSecondsValue)
    def intervalSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("intervalSeconds", intervalSecondsValue)
    def path: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", pathValue)
    def successCodes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("successCodes", successCodesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly {
    override def healthyThresholdValue: Option[Integer] =
      scala.Option(impl.healthyThreshold()).map(value => value: Integer)
    override def unhealthyThresholdValue: Option[Integer] =
      scala.Option(impl.unhealthyThreshold()).map(value => value: Integer)
    override def timeoutSecondsValue: Option[Integer] =
      scala.Option(impl.timeoutSeconds()).map(value => value: Integer)
    override def intervalSecondsValue: Option[Integer] =
      scala.Option(impl.intervalSeconds()).map(value => value: Integer)
    override def pathValue: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override def successCodesValue: Option[String] =
      scala.Option(impl.successCodes()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly =
    new Wrapper(impl)
}
