package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Container(
    image: Option[String] = None,
    command: Option[Iterable[String]] = None,
    environment: Option[Map[String, String]] = None,
    ports: Option[Map[
      String,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Container
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(
        ports.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.unwrap.toString
            })
            .asJava
        )
      )(_.portsWithStrings)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Container
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Container =
      io.github.vigoo.zioaws.lightsail.model.Container(
        imageValue.map(value => value),
        commandValue.map(value => value),
        environmentValue.map(value => value),
        portsValue.map(value => value)
      )
    def imageValue: Option[String]
    def commandValue: Option[List[String]]
    def environmentValue: Option[Map[String, String]]
    def portsValue: Option[Map[
      String,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol
    ]]
    def image: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", imageValue)
    def command: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", commandValue)
    def environment: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("environment", environmentValue)
    def ports: ZIO[Any, AwsError, Map[
      String,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol
    ]] = AwsError.unwrapOptionField("ports", portsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Container
  ) extends io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly {
    override def imageValue: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override def commandValue: Option[List[String]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def environmentValue: Option[Map[String, String]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def portsValue: Option[Map[
      String,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol
    ]] = scala
      .Option(impl.ports())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Container
  ): io.github.vigoo.zioaws.lightsail.model.Container.ReadOnly = new Wrapper(
    impl
  )
}
