package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CloudFormationStackRecordSourceInfo(
    resourceType: Option[
      io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceType
    ] = None,
    name: Option[NonEmptyString] = None,
    arn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo = {
    import CloudFormationStackRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceInfo
      .wrap(buildAwsValue())
}
object CloudFormationStackRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceInfo =
      io.github.vigoo.zioaws.lightsail.model
        .CloudFormationStackRecordSourceInfo(
          resourceTypeValue.map(value => value),
          nameValue.map(value => value),
          arnValue.map(value => value)
        )
    def resourceTypeValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceType
    ]
    def nameValue: Option[NonEmptyString]
    def arnValue: Option[NonEmptyString]
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def name: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly {
    override def resourceTypeValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceType
    ] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceType
          .wrap(value)
      )
    override def nameValue: Option[NonEmptyString] =
      scala.Option(impl.name()).map(value => value: NonEmptyString)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ): io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly =
    new Wrapper(impl)
}
