package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  BucketName,
  IsoDate,
  NonEmptyString
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Bucket(
    resourceType: Option[NonEmptyString] = None,
    accessRules: Option[io.github.vigoo.zioaws.lightsail.model.AccessRules] =
      None,
    arn: Option[NonEmptyString] = None,
    bundleId: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    url: Option[NonEmptyString] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    name: Option[BucketName] = None,
    supportCode: Option[NonEmptyString] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    objectVersioning: Option[NonEmptyString] = None,
    ableToUpdateBundle: Option[Boolean] = None,
    readonlyAccessAccounts: Option[Iterable[NonEmptyString]] = None,
    resourcesReceivingAccess: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess]
    ] = None,
    state: Option[io.github.vigoo.zioaws.lightsail.model.BucketState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Bucket
      .builder()
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(accessRules.map(value => value.buildAwsValue()))(
        _.accessRules
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(objectVersioning.map(value => value: java.lang.String))(
        _.objectVersioning
      )
      .optionallyWith(
        ableToUpdateBundle.map(value => value: java.lang.Boolean)
      )(_.ableToUpdateBundle)
      .optionallyWith(
        readonlyAccessAccounts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readonlyAccessAccounts)
      .optionallyWith(
        resourcesReceivingAccess.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcesReceivingAccess)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Bucket =
      io.github.vigoo.zioaws.lightsail.model.Bucket(
        resourceTypeValue.map(value => value),
        accessRulesValue.map(value => value.editable),
        arnValue.map(value => value),
        bundleIdValue.map(value => value),
        createdAtValue.map(value => value),
        urlValue.map(value => value),
        locationValue.map(value => value.editable),
        nameValue.map(value => value),
        supportCodeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        objectVersioningValue.map(value => value),
        ableToUpdateBundleValue.map(value => value),
        readonlyAccessAccountsValue.map(value => value),
        resourcesReceivingAccessValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        stateValue.map(value => value.editable)
      )
    def resourceTypeValue: Option[NonEmptyString]
    def accessRulesValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly]
    def arnValue: Option[NonEmptyString]
    def bundleIdValue: Option[NonEmptyString]
    def createdAtValue: Option[IsoDate]
    def urlValue: Option[NonEmptyString]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def nameValue: Option[BucketName]
    def supportCodeValue: Option[NonEmptyString]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def objectVersioningValue: Option[NonEmptyString]
    def ableToUpdateBundleValue: Option[Boolean]
    def readonlyAccessAccountsValue: Option[List[NonEmptyString]]
    def resourcesReceivingAccessValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess.ReadOnly
    ]]
    def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.BucketState.ReadOnly]
    def resourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def accessRules: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly
    ] = AwsError.unwrapOptionField("accessRules", accessRulesValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def bundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def url: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", urlValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def name: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", nameValue)
    def supportCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def objectVersioning: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("objectVersioning", objectVersioningValue)
    def ableToUpdateBundle: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundleValue)
    def readonlyAccessAccounts: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "readonlyAccessAccounts",
        readonlyAccessAccountsValue
      )
    def resourcesReceivingAccess: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourcesReceivingAccess",
      resourcesReceivingAccessValue
    )
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.BucketState.ReadOnly
    ] = AwsError.unwrapOptionField("state", stateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Bucket
  ) extends io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly {
    override def resourceTypeValue: Option[NonEmptyString] =
      scala.Option(impl.resourceType()).map(value => value: NonEmptyString)
    override def accessRulesValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly] =
      scala
        .Option(impl.accessRules())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.AccessRules.wrap(value)
        )
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def bundleIdValue: Option[NonEmptyString] =
      scala.Option(impl.bundleId()).map(value => value: NonEmptyString)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def urlValue: Option[NonEmptyString] =
      scala.Option(impl.url()).map(value => value: NonEmptyString)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def nameValue: Option[BucketName] =
      scala.Option(impl.name()).map(value => value: BucketName)
    override def supportCodeValue: Option[NonEmptyString] =
      scala.Option(impl.supportCode()).map(value => value: NonEmptyString)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def objectVersioningValue: Option[NonEmptyString] =
      scala.Option(impl.objectVersioning()).map(value => value: NonEmptyString)
    override def ableToUpdateBundleValue: Option[Boolean] =
      scala.Option(impl.ableToUpdateBundle()).map(value => value: Boolean)
    override def readonlyAccessAccountsValue: Option[List[NonEmptyString]] =
      scala
        .Option(impl.readonlyAccessAccounts())
        .map(value =>
          value.asScala.map { item =>
            item: NonEmptyString
          }.toList
        )
    override def resourcesReceivingAccessValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess.ReadOnly
    ]] = scala
      .Option(impl.resourcesReceivingAccess())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess
            .wrap(item)
        }.toList
      )
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.BucketState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.BucketState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Bucket
  ): io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly = new Wrapper(impl)
}
