package io.github.vigoo.zioaws.lightsail
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Port,
  DomainName,
  Ipv6Address,
  ContainerName,
  DomainEntryOptionsKeys,
  NonEmptyString,
  ResourceName,
  TagKey
}
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    type AutoSnapshotDate = String
    type Base64 = String
    type BucketName = String
    type CertificateName = String
    type ContainerLabel = String
    type ContainerName = String
    type ContainerServiceName = String
    type ContainerServiceScale = Int
    type DomainEntryOptionsKeys = String
    type DomainEntryType = String
    type DomainName = String
    type EligibleToRenew = String
    type IAMAccessKeyId = String
    type InUseResourceCount = Int
    type IncludeCertificateDetails = Boolean
    type Integer = Int
    type IpAddress = String
    type Ipv6Address = String
    type IsoDate = Instant
    type IssuerCA = String
    type KeyAlgorithm = String
    type MetricPeriod = Int
    type NonEmptyString = String
    type Port = Int
    type RenewalStatusReason = String
    type RequestFailureReason = String
    type ResourceArn = String
    type ResourceName = String
    type RevocationReason = String
    type SensitiveString = String
    type SerialNumber = String
    type StringMax256 = String
    type TagKey = String
    type TagValue = String
    type TimeOfDay = String
    type Timestamp = Instant
  }
  type AccessKeyList = List[io.github.vigoo.zioaws.lightsail.model.AccessKey]
  type AccessReceiverList =
    List[io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess]
  type AddOnList = List[io.github.vigoo.zioaws.lightsail.model.AddOn]
  type AddOnRequestList =
    List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest]
  type AlarmsList = List[io.github.vigoo.zioaws.lightsail.model.Alarm]
  type AttachedDiskList =
    List[io.github.vigoo.zioaws.lightsail.model.AttachedDisk]
  type AttachedDiskMap =
    Map[ResourceName, Iterable[io.github.vigoo.zioaws.lightsail.model.DiskMap]]
  type AutoSnapshotDetailsList =
    List[io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails]
  type AvailabilityZoneList =
    List[io.github.vigoo.zioaws.lightsail.model.AvailabilityZone]
  type BlueprintList = List[io.github.vigoo.zioaws.lightsail.model.Blueprint]
  type BucketBundleList =
    List[io.github.vigoo.zioaws.lightsail.model.BucketBundle]
  type BucketList = List[io.github.vigoo.zioaws.lightsail.model.Bucket]
  type BundleList = List[io.github.vigoo.zioaws.lightsail.model.Bundle]
  type CacheBehaviorList =
    List[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath]
  type CertificateStatusList =
    List[io.github.vigoo.zioaws.lightsail.model.CertificateStatus]
  type CertificateSummaryList =
    List[io.github.vigoo.zioaws.lightsail.model.CertificateSummary]
  type CloudFormationStackRecordList =
    List[io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecord]
  type CloudFormationStackRecordSourceInfoList = List[
    io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecordSourceInfo
  ]
  type ContactMethodsList =
    List[io.github.vigoo.zioaws.lightsail.model.ContactMethod]
  type ContactProtocolsList =
    List[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]
  type ContainerImageList =
    List[io.github.vigoo.zioaws.lightsail.model.ContainerImage]
  type ContainerMap =
    Map[ContainerName, io.github.vigoo.zioaws.lightsail.model.Container]
  type ContainerServiceDeploymentList =
    List[io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment]
  type ContainerServiceList =
    List[io.github.vigoo.zioaws.lightsail.model.ContainerService]
  type ContainerServiceLogEventList =
    List[io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent]
  type ContainerServiceMetadataEntry = Map[String, String]
  type ContainerServiceMetadataEntryList = List[Map[String, String]]
  type ContainerServicePowerList =
    List[io.github.vigoo.zioaws.lightsail.model.ContainerServicePower]
  type ContainerServicePublicDomains = Map[String, Iterable[String]]
  type ContainerServicePublicDomainsList = List[String]
  type DiskInfoList = List[io.github.vigoo.zioaws.lightsail.model.DiskInfo]
  type DiskList = List[io.github.vigoo.zioaws.lightsail.model.Disk]
  type DiskMapList = List[io.github.vigoo.zioaws.lightsail.model.DiskMap]
  type DiskSnapshotList =
    List[io.github.vigoo.zioaws.lightsail.model.DiskSnapshot]
  type DistributionBundleList =
    List[io.github.vigoo.zioaws.lightsail.model.DistributionBundle]
  type DistributionList =
    List[io.github.vigoo.zioaws.lightsail.model.LightsailDistribution]
  type DomainEntryList =
    List[io.github.vigoo.zioaws.lightsail.model.DomainEntry]
  type DomainEntryOptions = Map[DomainEntryOptionsKeys, String]
  type DomainList = List[io.github.vigoo.zioaws.lightsail.model.Domain]
  type DomainNameList = List[DomainName]
  type DomainValidationRecordList =
    List[io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord]
  type Environment = Map[String, String]
  type ExportSnapshotRecordList =
    List[io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord]
  type HeaderForwardList =
    List[io.github.vigoo.zioaws.lightsail.model.HeaderEnum]
  type HostKeysList =
    List[io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes]
  type InstanceEntryList =
    List[io.github.vigoo.zioaws.lightsail.model.InstanceEntry]
  type InstanceHealthSummaryList =
    List[io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary]
  type InstanceList = List[io.github.vigoo.zioaws.lightsail.model.Instance]
  type InstancePlatformList =
    List[io.github.vigoo.zioaws.lightsail.model.InstancePlatform]
  type InstancePortInfoList =
    List[io.github.vigoo.zioaws.lightsail.model.InstancePortInfo]
  type InstancePortStateList =
    List[io.github.vigoo.zioaws.lightsail.model.InstancePortState]
  type InstanceSnapshotList =
    List[io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot]
  type Ipv6AddressList = List[Ipv6Address]
  type KeyPairList = List[io.github.vigoo.zioaws.lightsail.model.KeyPair]
  type LoadBalancerConfigurationOptions = Map[
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName,
    String
  ]
  type LoadBalancerList =
    List[io.github.vigoo.zioaws.lightsail.model.LoadBalancer]
  type LoadBalancerTlsCertificateDomainValidationOptionList = List[
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ]
  type LoadBalancerTlsCertificateDomainValidationRecordList = List[
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ]
  type LoadBalancerTlsCertificateList =
    List[io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate]
  type LoadBalancerTlsCertificateSummaryList = List[
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary
  ]
  type LogEventList = List[io.github.vigoo.zioaws.lightsail.model.LogEvent]
  type MetricDatapointList =
    List[io.github.vigoo.zioaws.lightsail.model.MetricDatapoint]
  type MetricStatisticList =
    List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
  type NotificationTriggerList =
    List[io.github.vigoo.zioaws.lightsail.model.AlarmState]
  type OperationList = List[io.github.vigoo.zioaws.lightsail.model.Operation]
  type PartnerIdList = List[NonEmptyString]
  type PendingMaintenanceActionList =
    List[io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction]
  type PortInfoList = List[io.github.vigoo.zioaws.lightsail.model.PortInfo]
  type PortList = List[Port]
  type PortMap =
    Map[String, io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol]
  type RegionList = List[io.github.vigoo.zioaws.lightsail.model.Region]
  type RelationalDatabaseBlueprintList =
    List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint]
  type RelationalDatabaseBundleList =
    List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle]
  type RelationalDatabaseEventList =
    List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent]
  type RelationalDatabaseList =
    List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabase]
  type RelationalDatabaseParameterList =
    List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter]
  type RelationalDatabaseSnapshotList =
    List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot]
  type ResourceNameList = List[ResourceName]
  type StaticIpList = List[io.github.vigoo.zioaws.lightsail.model.StaticIp]
  type StringList = List[String]
  type SubjectAlternativeNameList = List[DomainName]
  type TagKeyList = List[TagKey]
  type TagList = List[io.github.vigoo.zioaws.lightsail.model.Tag]
}
