package io.github.vigoo.zioaws.lightsail.model
import java.lang.Integer
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ContainerServiceScale,
  ContainerServiceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateContainerServiceRequest(
    serviceName: ContainerServiceName,
    power: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ] = None,
    scale: Option[ContainerServiceScale] = None,
    isDisabled: Option[Boolean] = None,
    publicDomainNames: Option[Map[String, Iterable[String]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest = {
    import UpdateContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .optionallyWith(power.map(value => value.unwrap))(_.power)
      .optionallyWith(scale.map(value => value: Integer))(_.scale)
      .optionallyWith(isDisabled.map(value => value: java.lang.Boolean))(
        _.isDisabled
      )
      .optionallyWith(
        publicDomainNames.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.publicDomainNames)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceRequest
      .wrap(buildAwsValue())
}
object UpdateContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceRequest =
      io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceRequest(
        serviceNameValue,
        powerValue.map(value => value),
        scaleValue.map(value => value),
        isDisabledValue.map(value => value),
        publicDomainNamesValue.map(value => value)
      )
    def serviceNameValue: ContainerServiceName
    def powerValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ]
    def scaleValue: Option[ContainerServiceScale]
    def isDisabledValue: Option[Boolean]
    def publicDomainNamesValue: Option[Map[String, List[String]]]
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
    def power: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ] = AwsError.unwrapOptionField("power", powerValue)
    def scale: ZIO[Any, AwsError, ContainerServiceScale] =
      AwsError.unwrapOptionField("scale", scaleValue)
    def isDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDisabled", isDisabledValue)
    def publicDomainNames: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("publicDomainNames", publicDomainNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
    override def powerValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ] = scala
      .Option(impl.power())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
          .wrap(value)
      )
    override def scaleValue: Option[ContainerServiceScale] =
      scala.Option(impl.scale()).map(value => value: ContainerServiceScale)
    override def isDisabledValue: Option[Boolean] =
      scala.Option(impl.isDisabled()).map(value => value: Boolean)
    override def publicDomainNamesValue: Option[Map[String, List[String]]] =
      scala
        .Option(impl.publicDomainNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceRequest.ReadOnly =
    new Wrapper(impl)
}
