package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest = {
    import StartRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object StartRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseRequest =
      io.github.vigoo.zioaws.lightsail.model
        .StartRelationalDatabaseRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
  ): io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
