package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceReceivingAccess(
    name: Option[NonEmptyString] = None,
    resourceType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess = {
    import ResourceReceivingAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess
      .wrap(buildAwsValue())
}
object ResourceReceivingAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess =
      io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess(
        nameValue.map(value => value),
        resourceTypeValue.map(value => value)
      )
    def nameValue: Option[NonEmptyString]
    def resourceTypeValue: Option[NonEmptyString]
    def name: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", nameValue)
    def resourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceType", resourceTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
  ) extends io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess.ReadOnly {
    override def nameValue: Option[NonEmptyString] =
      scala.Option(impl.name()).map(value => value: NonEmptyString)
    override def resourceTypeValue: Option[NonEmptyString] =
      scala.Option(impl.resourceType()).map(value => value: NonEmptyString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
  ): io.github.vigoo.zioaws.lightsail.model.ResourceReceivingAccess.ReadOnly =
    new Wrapper(impl)
}
