package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReleaseStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest = {
    import ReleaseStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
      .builder()
      .staticIpName(staticIpName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpRequest
      .wrap(buildAwsValue())
}
object ReleaseStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpRequest =
      io.github.vigoo.zioaws.lightsail.model
        .ReleaseStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: ResourceName
    def staticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpRequest.ReadOnly {
    override def staticIpNameValue: ResourceName =
      impl.staticIpName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
  ): io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpRequest.ReadOnly =
    new Wrapper(impl)
}
